/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;

public class Galactic
extends Astroframe {
    static final char letterIAU = 'G';
    public static final double[] toFK4matrix = new double[]{-0.06698873941515071, 0.49272846607532356, -0.8676008111514348, -0.8727557658519927, -0.45034695801996133, -0.18837460172292045, -0.48353891463218424, 0.744584633283031, 0.46019978478385165};
    public static final double[] fromICRSbase = new double[]{-0.05487565771261968, -0.8734370519557791, -0.48383507361641837, 0.49410943719710765, -0.4448297212220538, 0.7469821839845094, -0.8676661375571626, -0.1980763372750706, 0.4559838136911524};
    public static final double[] toICRSbase = new double[]{-0.05487565771261968, 0.49410943719710765, -0.8676661375571626, -0.8734370519557791, -0.4448297212220538, -0.1980763372750706, -0.48383507361641837, 0.7469821839845094, 0.4559838136911524};
    public static final double[] toHIPmatrix = AstroMath.rotation("zyz", 192.85948, 62.87175, 57.06808);

    public static Galactic scan(double d) {
        if (DEBUG) {
            System.out.println("#...Galactic.scan(" + d + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        boolean bl = Double.isNaN(d);
        for (Object e : fixedFrames) {
            if (!(e instanceof Galactic)) continue;
            Galactic galactic = (Galactic)e;
            if (galactic.toICRSmatrix != toICRSbase || !bl && !(Math.abs(galactic.epoch - d) <= 3.168808781402895E-8)) continue;
            return galactic;
        }
        return null;
    }

    public static Galactic create(double d) {
        Galactic galactic = Galactic.scan(d);
        if (galactic == null) {
            galactic = new Galactic(d);
            galactic.fixFrame();
        }
        return galactic;
    }

    public static Galactic create() {
        return Galactic.create(2000.0);
    }

    public Galactic(double d) {
        if (Double.isNaN(d)) {
            d = 2000.0;
        }
        this.precision = (byte)7;
        this.epoch = d;
        this.name = "Galactic";
        this.full_name = this.name + "(Ep=J" + d + ")";
        this.toICRSmatrix = toICRSbase;
        this.fromICRSmatrix = fromICRSbase;
    }

    public static Galactic Gaia2() {
        String string = "Galactic-Gaia2";
        Galactic galactic = (Galactic)Galactic.getFrame(string);
        if (galactic == null) {
            galactic = new Galactic(2015.5);
            galactic.toICRSmatrix = toHIPmatrix;
            galactic.fromICRSmatrix = AstroMath.rot_inv(toHIPmatrix);
            galactic.fixed = (byte)(galactic.fixed | 1);
            galactic.precision = (byte)9;
            galactic.name = galactic.full_name = string;
            galactic.fixFrame(string);
        }
        return galactic;
    }

    public static Astroframe Hipparcos() {
        String string = "Gal-Hip";
        Galactic galactic = (Galactic)Galactic.getFrame(string);
        if (galactic == null) {
            galactic = new Galactic(1991.25);
            galactic.toICRSmatrix = toHIPmatrix;
            galactic.fromICRSmatrix = AstroMath.rot_inv(toHIPmatrix);
            galactic.fixed = (byte)(galactic.fixed | 1);
            galactic.precision = (byte)9;
            galactic.name = galactic.full_name = string;
            galactic.fixFrame(string);
        }
        return galactic;
    }
}

